/*
 *  Kod z ksiki
 *  Programowanie w jzyku C. FAQ
 *  Addison-Wesley, 1996, ISBN 0-201-84519-9
 *  (pytanie 20.17)
 *
 *  Ten kod moe by dowolnie uywany i modyfikowany,
 *  bez adnych ogranicze.
 */

#include <stdio.h>

#define CODE_APPLE	1
#define CODE_ORANGE	2
#define CODE_NONE	0

#ifdef __STDC__
int classifyfunc(char *);
#endif

main()
{
	char *string = "jabko";

	switch(classifyfunc(string)) {
	case CODE_APPLE:
		printf("jabko\n");
		break;

	case CODE_ORANGE:
		printf("pomaracza\n");
		break;

	case CODE_NONE:
		printf("co innego\n");
		break;
	}

	return 0;
}

static struct lookuptab {
	char *string;
	int code;
} tab[] = {
	{"jabko",	CODE_APPLE},
	{"pomaracza",	CODE_ORANGE},
};

classifyfunc(char *string)
{
	int i;
	for(i = 0; i < sizeof(tab) / sizeof(tab[0]); i++)
		if(strcmp(tab[i].string, string) == 0)
			return tab[i].code;

	return CODE_NONE;
}
